VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "MM_Hash"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'* KEEP in MIND that the String Index of VBA is 1, and that I am using 0 to mean NULL/NOTHING/EMPTY
'* ALL HASH STRUCTURE IS #KEY1%VALUE1#KEY2%VALUE2#


Public Function DefineHashStringFromFile() As String
 '# this sub converts a text-type deliminated (e.g. TAB-deliminated) file
 '# into a KEY%VALUE# string for quick access
 '# must be KEY \t VALUE \n
 '# returns the HASHstring
 
 Dim fsO, OutFileObj, readDatei, atLINE
 Dim FolderRoot, FileFolder, InputFileName
    Set fsO = CreateObject("Scripting.FileSystemObject")
 Dim lineSPLITED

'* input will be FASTA
frmFile.Caption = "Read which HASH text file ('\t' delimited):"
frmFile.Show
InputFileName = frmFile.lblPath.Caption

'open file to get data column names
Set readDatei = fsO.OpenTextFile(InputFileName)

DefineHashStringFromFile = "#"
Do
atLINE = readDatei.readLine
lineSPLITED = Split(atLINE, vbTab, , vbBinaryCompare)
DefineHashStringFromFile = DefineHashStringFromFile + (lineSPLITED(0) & "%" & lineSPLITED(1) & "#")
Loop Until readDatei.atEndofStream
readDatei.Close 'close it, since we will have to make multiple passes

End Function

Public Function DefineHashStringFromArrays(KeyArray, ValueArray) As String
 '# this sub converts a text-type deliminated (e.g. TAB-deliminated) file
 '# into a KEY%VALUE# string for quick access
 '# must be KEY \t VALUE \n
 '# returns the HASHstring
 
Dim k_ctr As Long

If UBound(KeyArray) <> UBound(ValueArray) Then
 DefineHashStringFromArrays = ""
Else
 DefineHashStringFromArrays = "#"
 For k_ctr = 1 To UBound(KeyArray)
  DefineHashStringFromArrays = DefineHashStringFromArrays + (KeyArray(k_ctr) & "%" & ValueArray(k_ctr) & "#")
 Next k_ctr
End If

End Function

Public Function FindKeyPositonInHash(ByVal HashString As String, sKey As String, IgnoreCaseOpt As Integer) As String
 
 '* HASH is "KEY%VALUE#"
 
Dim reGGExpLocal
    Set reGGExpLocal = New RegExp
Dim r1Matches
Dim subSTRING
    subSTRING = ""
    
 If IgnoreCaseOpt = 1 Then
       
 If InStr(1, UCase(HashString), ("#" + UCase(sKey) + "%")) > 0 Then
 subSTRING = Mid(HashString, 1, InStr(1, HashString, "#" + UCase(sKey) + "%"))
 End If
 reGGExpLocal.Pattern = "#"
 reGGExpLocal.Global = True
 reGGExpLocal.IgnoreCase = True
 
 ElseIf IgnoreCaseOpt = 0 Then
 
 If InStr(1, HashString, ("#" + sKey + "%")) > 0 Then
 subSTRING = Mid(HashString, 1, InStr(1, HashString, "#" + UCase(sKey) + "%"))
 End If
 reGGExpLocal.Pattern = "#"
 reGGExpLocal.Global = True
 reGGExpLocal.IgnoreCase = False
 End If
 
 Set r1Matches = reGGExpLocal.Execute(subSTRING)

 FindKeyPositonInHash = r1Matches.Count
End Function

Public Function ValueFromUniqueKeyAsString(ByVal HashString As String, KeyAsString As String) As String

Dim reGGExpLocal As New RegExp
Dim r0Matches, rmatch
Dim tempSTR As String

 '* returns a the string value
 '* HASH is "KEY%VALUE#"
 
 'stringtest = "#key1%value001#key2%value002#"
 
 reGGExpLocal.Pattern = "#" + KeyAsString + "%([^#]+)#"
 reGGExpLocal.Global = True
 reGGExpLocal.IgnoreCase = True
 reGGExpLocal.IgnoreCase = True
 Set r0Matches = reGGExpLocal.Execute(HashString)

 If r0Matches.Count = 1 Then  '* only one match allowed
  For Each rmatch In r0Matches
   tempSTR = Mid(HashString, rmatch.FirstIndex + 1, rmatch.length)
   ValueFromUniqueKeyAsString = Mid(tempSTR, InStr(1, tempSTR, "%") + 1, Len(tempSTR) - InStr(1, tempSTR, "%") - 1)
  Next
 Else
  ValueFromUniqueKeyAsString = ""
 End If

End Function

Public Function KeysFromValue(ByVal HashString As String, Values As String)
'* returns an array of Key matches
 '* HASH is "KEY%VALUE#"

Dim tempKEYS()
    ReDim tempKEYS(0)
Dim reGGExpLocal As New RegExp
Dim r0Matches, rmatch
Dim tempSTR As String
 
 'stringtest = "#key1%value001#key2%value002#"
 
 reGGExpLocal.Pattern = "#([^%]+)%" + Values + "#"
 reGGExpLocal.Global = True
 reGGExpLocal.IgnoreCase = True
 reGGExpLocal.IgnoreCase = True
 Set r0Matches = reGGExpLocal.Execute(HashString)

 If r0Matches.Count > 0 Then
 
  For Each rmatch In r0Matches
   tempSTR = Mid(HashString, rmatch.FirstIndex + 1, rmatch.length)
   ReDim Preserve tempKEYS(UBound(tempKEYS) + 1)
   tempKEYS(UBound(tempKEYS)) = Mid(tempSTR, 2, InStr(1, tempSTR, "%") - 2)
  Next
 
 Else
   tempKEYS(0) = 0
 End If
 
 KeysFromValue = tempKEYS

End Function

Public Function KeyByPosition(ByVal HashString As String, KeyPosition As Long) As String
Dim tempSPLIT

HashString = Mid(HashString, 2, Len(HashString) - 2)

tempSPLIT = Split(HashString, "#", , vbBinaryCompare)

KeyByPosition = ""

If tempSPLIT(0) = HashString Then
                '* no split match was possible, same string is returned as 0-element
 'Exit Function  '* return nothing

Else

 '* the SPLIT function is ZERO-INDEXED
 If (KeyPosition - 1) <= UBound(tempSPLIT) Then
  KeyByPosition = Mid(tempSPLIT(KeyPosition - 1), 1, InStr(1, tempSPLIT(KeyPosition - 1), "%") - 1)
 End If


End If

End Function


